// Playground - noun: a place where people can play

import UIKit

var str = "Hello, playground"

class Plant {
    var height: Double = 0.0 {
        didSet {
            print("Roślina ma teraz wysokość \(height) cm.")
        }
    }
    var age = 0
    
    var description: String {
        get {
            return "Klasa bazowa to Plant."
        }
    }
    
    func growHeight(inches: Double) {
        self.height += inches
    }
    
    func getDetails() -> String {
        return "Wysokość: \(self.height)  wiek:  \(self.age)"
    }
}


class Tree: Plant {
    var limbs = 0
    
    override var height: Double {
        didSet {
            print("Drzewo ma teraz wysokość \(height) cm.")
        }
    }
    
    override var description: String {
        return "\(super.description)  To jest egzemplarz klasy Tree."
    }
    
    func limbGrow() {
        self.limbs += 1
    }
    func limbFall() {
        self.limbs -= 1
    }
    override func getDetails() -> String {
        return " \(super.getDetails()) konary:  \(self.limbs)"
    }
}


class PineTree: Tree {
    var needles = 0
    
    override func getDetails() -> String{
        return " \(super.getDetails())  igły:  \(self.needles)"
    }
}

class OakTree: Tree {
    var leaves = 0
    override func getDetails() -> String{
        return " \(super.getDetails())  liście:  \(self.leaves)"
    }
}

var tree = Tree()
print(tree.description)
tree.height = 25
tree.limbGrow()
tree.limbGrow()
print(tree.limbs)

